
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 15 10:19:22 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_HASHFLOW_Acceptance_test_vectors.c#1:csrc:1
   *  \author 
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/***************************
 * File Name:                                                           
 *  RYS_SYS_TST_HASHFLOW_Acceptance_test_vectors.c       
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for FLOW Acceptance tests                              
 *
 **************************/
 
 /***** Include Files ******/
#include "CRYS_ATP_TST_HASHFLOW_Acceptance.h"
#include "CRYS_ATP_TST_Defines.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/



/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
/****** **** Public Functions *****/
/******** Private Functions ******/
/*****************************/
/************** External Key Vectors  ********/
/*****************************/

TST_HASHFLOW_TestDataStruct TST_HASHFLOW_Acceptance_TestData[] =
{
        /************/
        /*        static FLOW vectors         */
        /************/
	#if TST_USE_FLOW_HASH_SHA1Mode_DATA
	{ 
        {"Acceptance flow test - HASH/512ByteData/SHA1 "},
        /* input interrupt id */
        2,
    
        /* output interrupt id */
        3,
  
        /* if the data in the buffers are in words and not bytes */ 
        0,
  
        /* number of input buffers */
        /* buffer size should be modulos 64 except a last block, that can be any size */
        4,
    
        /* flag if  endian order of the input buffers is big */
        0,
  
        /* number of output buffers */
        0,
        0,
        /* TST_Expected_output_data */
        {
			0xD2,0x2A,0xA9,0x94,0x2F,0x2F,0xAA,0xD7,0x35,0x69,0xE7,0xC3,0x42,0x5C,0xC6,0x33,
			0xC6,0x80,0x06,0x90
        },
        /*{
            0x94, 0xA9, 0x2A, 0xD2, 0xD7, 0xAA, 0x2F, 0x2F, 0xC3, 0xE7, 0x69, 0x35, 0x33, 0xC6, 0x5C, 0x42,
            0x90, 0x06, 0x80, 0xC6
        },*/
        /* TST_Expected_cyclicOperation_data */
        {
            0x75,0xE4,0x64,0x35,0x08,0x2A,0x5B,0x98,0x0D,0xF9,0xDB,0x50,0xA0,0xED,0x15,0x03,
            0xC8,0x39,0x6D,0xEE
        },
        /* TST_Expected_dataSize */
		CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
        CRYS_HASH_SHA1_mode,
    },
	#endif
	#if TST_USE_FLOW_HASH_SHA224Mode_DATA
	{ 
		{"Acceptance flow test - HASH/512ByteData/SHA224 "},
			/* input interrupt id */
			2,

			/* output interrupt id */
			3,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			8,

			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			0,
			0,
			/* TST_Expected_output_data */
		{
			0x42,0x19,0x65,0xF6,0x5B,0xAE,0x13,0xA5,0xAC,0x04,0x45,0x7A,0x28,0x87,0xE6,0x2B,
			0x28,0xCA,0x08,0x4E,0x55,0x43,0x6F,0x2F,0x3F,0xC5,0xB1,0xAF
		},
		
		/* TST_Expected_cyclicOperation_data */
		{
		    0xBE,0x0C,0xC5,0x26,0xD5,0xA7,0x3A,0xB4,0x28,0xC2,0x34,0xAE,0x9A,0xA0,0x80,0x0D,
            0x67,0x16,0xD7,0x10,0xAC,0x03,0x48,0x12,0x32,0x1A,0x41,0x17
		},
		/* TST_Expected_dataSize */
		CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
		CRYS_HASH_SHA224_mode,
	},
	#endif
	#if TST_USE_FLOW_HASH_SHA256Mode_DATA
	{ 
		{"Acceptance flow test - HASH/512ByteData/SHA256 "},
			/* input interrupt id */
			0,

			/* output interrupt id */
			1,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			8,

			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			0,
			0,
			/* TST_Expected_output_data */
		{
			0x29,0x0C,0xC6,0x4F,0xDB,0x32,0x85,0x81,0x90,0xF2,0x8E,0x42,0x91,0xEE,0x18,0xA1,
			0xC1,0x16,0x5F,0x4E,0x32,0xC9,0x29,0x47,0x04,0x16,0x95,0xD8,0x5F,0x66,0x24,0x9D
		},
		/* TST_Expected_cyclicOperation_data */
		{
		    0x1B,0xA0,0x6F,0x9D,0xF3,0xD2,0xCE,0x65,0xD6,0xCE,0xE7,0x82,0xBB,0x67,0x96,0x8F,
            0x37,0x60,0x70,0x76,0x2E,0x7B,0x39,0xC3,0x22,0xAE,0xA4,0xB7,0x28,0x2E,0xFE,0xEB

		},
		/* TST_Expected_dataSize */
		CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
		CRYS_HASH_SHA256_mode,
	},
	#endif    
	#if TST_USE_FLOW_HASH_SHA384Mode_DATA
	{ 
		{"Acceptance flow test - HASH/512ByteData/SHA384 "},
			/* input interrupt id */
			0,

			/* output interrupt id */
			1,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			4, /* must be because hash block size should be multiple of 128 bytes */ 

			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			0,
			0,
			/* TST_Expected_output_data */
		{
			0x88,0x2B,0xF7,0xBB,0x4E,0x62,0xBD,0x84,0xAE,0x19,0x8D,0x1F,0x66,0x91,0xFB,0x7F,
			0x56,0xA7,0xE6,0x08,0xF3,0x71,0x94,0x1C,0x1A,0xBC,0xA8,0x73,0xB5,0x2B,0x19,0x13,
			0xFE,0x77,0x76,0x67,0x27,0x4F,0x74,0x6F,0x55,0x6A,0x87,0xA3,0x12,0x8C,0x17,0x92			
		},
		/* TST_Expected_cyclicOperation_data */
		{
		    0x63,0x10,0xB5,0x4C,0x8E,0x5B,0x6D,0x96,0x33,0x54,0x7E,0xD7,0x3B,0x87,0x95,0x9C,
            0x96,0xA2,0xC4,0xE9,0x02,0x26,0x99,0x27,0x8A,0xA4,0xED,0x3F,0x52,0x93,0x95,0xB2,
            0x62,0xD9,0xD1,0x34,0x65,0x3D,0x57,0x77,0x73,0x02,0x89,0x3D,0xDC,0xB8,0xD8,0xE3  
		},
		/* TST_Expected_dataSize */
		CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
		CRYS_HASH_SHA384_mode,
	},
	#endif    
	#if TST_USE_FLOW_HASH_SHA512Mode_DATA
	{ 
		{"Acceptance flow test - HASH/512ByteData/SHA512 "},
			/* input interrupt id */
			0,

			/* output interrupt id */
			1,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			4, /* must be because hash block size should be multiple of 128 bytes */ 

			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			0,
			0,
			/* TST_Expected_output_data */
		{
			0xFA,0x8D,0x64,0x77,0x70,0x8D,0xD9,0xAE,0x64,0xC7,0xA7,0xDD,0x37,0x5A,0xD8,0x30,
			0xE1,0x60,0x17,0x9F,0xA7,0xB6,0x6A,0xC8,0x17,0xDB,0xC3,0x37,0x8D,0x8A,0x9D,0x05,
			0xC6,0x77,0x29,0x89,0x20,0xE7,0x3C,0x3C,0xCD,0x68,0xFF,0xCA,0x2E,0x0C,0x8D,0x09,
			0x72,0x65,0xF8,0x0A,0xBE,0xA8,0xCA,0xFF,0x08,0xF9,0xF9,0x05,0xE8,0xD5,0xFC,0x4A			
		},
		/* TST_Expected_cyclicOperation_data */
		{
		    0xD4,0x03,0x05,0x34,0x43,0x5A,0x42,0x27,0x59,0x2C,0x59,0xA4,0x73,0x61,0xF1,0x98,
            0x6B,0x2E,0x55,0x3F,0xF0,0x14,0xA9,0x8E,0xAD,0xF5,0xAD,0xEA,0x72,0x17,0x59,0xCF,
            0x91,0x65,0x40,0xC3,0x7C,0xC4,0x1E,0x3E,0x22,0x8A,0x70,0x0F,0xDC,0x38,0x39,0x8F,
            0xB5,0xFA,0xD1,0xD5,0x91,0xF7,0x30,0xE0,0xD9,0xCE,0xC5,0xAF,0xC9,0xD9,0x4F,0xE1
		},
		/* TST_Expected_dataSize */
		CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
		CRYS_HASH_SHA512_mode,
	},
	#endif    
	#if TST_USE_FLOW_HASH_MD5Mode_DATA
	{ 
		{"Acceptance flow test - HASH/512ByteData/MD5 "},
			/* input interrupt id */
			0,

			/* output interrupt id */
			1,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			8,

			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			0,
			0,
			/* TST_Expected_output_data */
		{
			0x69,0x69,0xDF,0x30,0x08,0x76,0x55,0x67,0x0F,0xCD,0x67,0xEE,0xED,0xD7,0x66,0x9B
		},
		   /* TST_Expected_cyclicOperation_data */
		{
		    0xED,0x25,0xBF,0x1E,0xDF,0x4A,0xE0,0x93,0x05,0xE3,0x59,0xDD,0xF1,0x0E,0x7C,0x74
		},
		/* TST_Expected_dataSize */
		CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
		CRYS_HASH_MD5_mode,
	},
	#endif    
};

const int TST_NumberOf_HASHFLOW_AcceptanceTests      = sizeof(TST_HASHFLOW_Acceptance_TestData)/sizeof(TST_HASHFLOW_Acceptance_TestData[0]);

#endif

